/**
 * Marlin 3D Printer Firmware
 * Copyright (C) 2016 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (C) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * Custom Bitmap for splashscreen
 *
 * You may use one of the following tools to generate the C++ bitmap array from
 * a black and white image:
 *
 *  - http://www.marlinfw.org/tools/u8glib/converter.html
 *  - http://www.digole.com/tools/PicturetoC_Hex_converter.php
 */
//custom screen can be up to 112 wide and 64 high

#include <avr/pgmspace.h>

#define CUSTOM_BOOTSCREEN_TIMEOUT   2500
#define CUSTOM_BOOTSCREEN_BMPWIDTH  112
#define CUSTOM_BOOTSCREEN_BMPHEIGHT 64

// Width: 112, Height: 64
const unsigned char custom_start_bmp[896] PROGMEM = {
  0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x00, 0x00, 0x01, 0xf9, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x01, 0xc0, 0x01,
  0x80, 0x00, 0x00, 0x06, 0x4d, 0x00, 0x00, 0x07, 0x38, 0x00, 0x00, 0x01, 0xc0, 0x01,
  0x80, 0x00, 0x00, 0x0c, 0x26, 0x00, 0x0e, 0xe7, 0x39, 0xd3, 0xe1, 0xf3, 0xe7, 0xc1,
  0x80, 0x00, 0x00, 0x19, 0x12, 0x00, 0x0f, 0xe7, 0x39, 0xf7, 0xf3, 0xfb, 0xef, 0xe1,
  0x80, 0x00, 0x00, 0x37, 0xce, 0x00, 0x0e, 0xe7, 0x01, 0xf7, 0x73, 0xb9, 0xce, 0xe1,
  0x80, 0x00, 0x00, 0x64, 0x66, 0x00, 0x0e, 0xe7, 0x01, 0xc7, 0xf3, 0xb9, 0xcf, 0xe1,
  0x80, 0x00, 0x00, 0x4b, 0xa6, 0x00, 0x0e, 0xe7, 0x39, 0xc7, 0xf0, 0xf9, 0xcf, 0xe1,
  0x80, 0x00, 0x00, 0xca, 0xb4, 0x00, 0x0f, 0xe7, 0x39, 0xc7, 0x03, 0xf9, 0xce, 0x01,
  0x80, 0x00, 0x00, 0xcd, 0xa4, 0x00, 0x06, 0xe7, 0x39, 0xc7, 0x73, 0xb9, 0xce, 0xe1,
  0x80, 0x00, 0x03, 0xa6, 0x6c, 0x00, 0x00, 0xe7, 0x39, 0xc7, 0x73, 0xb9, 0xce, 0xe1,
  0x80, 0x00, 0xff, 0x13, 0xd8, 0x00, 0x0e, 0xe3, 0xf1, 0xc7, 0xf3, 0xf9, 0xef, 0xe1,
  0x80, 0x01, 0x21, 0x88, 0x18, 0x00, 0x0f, 0xe1, 0xe1, 0xc3, 0xe1, 0xb9, 0xe7, 0xc1,
  0x80, 0x06, 0x61, 0x16, 0x30, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x04, 0x41, 0x23, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x04, 0xfe, 0x41, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x0b, 0x86, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1f, 0x80, 0x00, 0x00, 0x01,
  0x80, 0x1e, 0x01, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1f, 0x80, 0x00, 0x00, 0x01,
  0x80, 0x1c, 0x07, 0x22, 0x00, 0x00, 0x07, 0xbc, 0x3f, 0x9f, 0x81, 0xf8, 0xf1, 0xe1,
  0x80, 0x08, 0x1f, 0xe2, 0x00, 0x00, 0x0f, 0xfc, 0x3f, 0xbf, 0x87, 0xfe, 0x71, 0xc1,
  0x80, 0x00, 0x33, 0x62, 0x00, 0x00, 0x0f, 0x3c, 0x3d, 0xb7, 0x87, 0x9e, 0x7b, 0xc1,
  0x80, 0x00, 0xc2, 0x22, 0x00, 0x00, 0x0f, 0x3c, 0x3d, 0xb7, 0x87, 0x9e, 0x7b, 0xc1,
  0x80, 0x00, 0xc2, 0x3e, 0x00, 0x00, 0x0f, 0x3c, 0x3d, 0xf7, 0x80, 0x7e, 0x3b, 0x81,
  0x80, 0x01, 0xe6, 0x1e, 0x00, 0x00, 0x0f, 0x3c, 0x3d, 0xf7, 0x83, 0xfe, 0x3f, 0x81,
  0x80, 0x01, 0x3c, 0x12, 0x00, 0x00, 0x0f, 0x3c, 0x3d, 0xf7, 0x87, 0x9e, 0x3b, 0x81,
  0x80, 0x01, 0x1c, 0x26, 0x00, 0x00, 0x0f, 0xfc, 0x3d, 0xf7, 0x87, 0x9e, 0x7b, 0xc1,
  0x80, 0x01, 0x70, 0x64, 0x00, 0x00, 0x07, 0xbc, 0x3c, 0xe7, 0x87, 0x9e, 0x7b, 0xc1,
  0x80, 0x03, 0xc0, 0x58, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0xe7, 0x87, 0xfe, 0x71, 0xc1,
  0x80, 0x0d, 0x80, 0xf0, 0x00, 0x00, 0x0f, 0x3c, 0x3c, 0xe7, 0x83, 0xde, 0xf1, 0xe1,
  0x80, 0x1a, 0x00, 0xe0, 0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x26, 0x00, 0x40, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x80, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,

  0x81, 0x06, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1c, 0x03, 0xc0, 0x20, 0x10, 0x00, 0x01,
  0x83, 0x24, 0x00, 0x00, 0x00, 0x00, 0x08, 0x92, 0x02, 0x20, 0x00, 0x10, 0x00, 0x01,
  0x02, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0x02, 0x23, 0x27, 0x39, 0x8c, 0xe1,
  0x06, 0x38, 0x00, 0x00, 0x00, 0x00, 0x03, 0x11, 0x03, 0xc2, 0x24, 0x92, 0x49, 0x01,
  0x04, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0x02, 0x02, 0x24, 0x93, 0xc8, 0xc1,
  0x0d, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x08, 0x92, 0x02, 0x02, 0x24, 0x92, 0x08, 0x21,
  0x08, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1c, 0x02, 0x02, 0x24, 0x99, 0xc9, 0xc1,
  0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,

  0x10, 0x30, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x0f, 0xe0, 0x0f, 0x00, 0x01,
  0x30, 0x20, 0x00, 0x37, 0x00, 0x00, 0x00, 0x12, 0x24, 0x08, 0x10, 0x09, 0x00, 0x01,
  0x20, 0x30, 0x00, 0x6d, 0x80, 0x00, 0x00, 0x12, 0x24, 0x09, 0x88, 0x09, 0x00, 0x01,
  0x10, 0x18, 0x1f, 0x60, 0xc0, 0x00, 0x00, 0x12, 0x24, 0x09, 0x48, 0x09, 0x00, 0x01,
  0x30, 0x0c, 0x39, 0xe0, 0x60, 0x00, 0x00, 0x12, 0x24, 0x09, 0x90, 0x09, 0x00, 0x01,
  0x30, 0x07, 0x90, 0x70, 0x60, 0x00, 0x00, 0x12, 0x24, 0x08, 0x60, 0x09, 0x00, 0x01,
  0x10, 0x16, 0xf0, 0x18, 0x20, 0x00, 0x00, 0x12, 0x24, 0x08, 0x10, 0x09, 0x00, 0x01,
  0x1a, 0x10, 0x60, 0x08, 0x30, 0x00, 0x00, 0x12, 0x24, 0x09, 0xc8, 0x09, 0x00, 0x01,
  0x0b, 0x09, 0x80, 0x00, 0x30, 0x00, 0x00, 0x12, 0x24, 0x09, 0x24, 0x09, 0x00, 0x01,
  0x0e, 0x07, 0x80, 0x00, 0x10, 0x00, 0x00, 0x13, 0xe4, 0x89, 0xc4, 0x89, 0xf9, 0x01,
  0x06, 0x1e, 0x40, 0x10, 0x10, 0x00, 0x00, 0x10, 0x05, 0xc8, 0x09, 0xc8, 0x0b, 0x81,
  0x06, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x0f, 0xf8, 0x8f, 0xf0, 0x8f, 0xf9, 0x01,
  0x03, 0x80, 0x00, 0x20, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x01, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};
